/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.io.File;
import java.io.FileOutputStream;

import com.inet.report.Engine;

/**
 * This sample shows how you can change the table name at runtime. The new table should contains the same columns.
 */
public class ChangeDatabaseTableNameAtRuntime {

    /**
     * Runs a simple export of a report file using RDC methods.
     */
    public ChangeDatabaseTableNameAtRuntime() {
        try {
            Engine eng = new Engine( Engine.EXPORT_PDF );
            eng.setReportFile( "samples/rdc/ChangeTableName.rpt" );

            // Change the table name from "Orders" to "Order Details". Both tables contains the used column "OrderID".
            eng.getDatabaseTables().getTablesource( "Orders" ).setDatabaseIdentifierName( "Order Details" );

            eng.execute();
            File pdfFile = new File( "ChangeTableName.pdf" );
            FileOutputStream fos = new FileOutputStream( pdfFile );
            for( int i = 1; i <= eng.getPageCount(); i++ ) {
                fos.write( eng.getPageData( i ) );
            }
            fos.close();
        } catch( Throwable t ) {
            t.printStackTrace();
        }
    }

    /**
     * Main method, runs the sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new ChangeDatabaseTableNameAtRuntime();
    }
}
